

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

float		LOD_firstLevel;
float		LOD_nextLevel;
float3		eyePosition;
float2		sectionPosition;
float		sectionSize;
float		mapSize;

#define		SHADOW_EPSILON 0.001f

float		g_light_farPlane;
float4x4	g_shadowerTransform;
float		shader_misc_shadow_mapSize;
float		shader_misc_shadow_mapTexelSize;

///////////////////////////////////////////////////////////

struct VS_INPUT 
{
	float4	position	:	POSITION;
	float2	uv			:	TEXCOORD0;
	float	height		:	TEXCOORD1;
	float	nextHeight	:	TEXCOORD2;
};
	
///////////////////////////////////////////////////////////

struct VS_OUTPUT 
{
	float4	position		:	POSITION;

	float4	posTex			:	TEXCOORD0;
	float	depth			:	TEXCOORD1;
};

///////////////////////////////////////////////////////////

VS_OUTPUT vs_terrain_shadowed( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;
	
	output.position = float4(input.position.x,input.height,input.position.z,1);
	
	float nLodDistance = sqrt((eyePosition.x-output.position.x)*(eyePosition.x-output.position.x) + (eyePosition.y-output.position.y)*(eyePosition.y-output.position.y) + (eyePosition.z-output.position.z)*(eyePosition.z-output.position.z));
	float nLodChangePoint = LOD_nextLevel - (LOD_nextLevel - LOD_firstLevel) * 0.25f;

	if (nLodDistance >= nLodChangePoint)
	{
		output.position.y = lerp( input.height, input.nextHeight, clamp((nLodDistance - nLodChangePoint) / ((LOD_nextLevel - LOD_firstLevel) * 0.25f),0,1) );
	}

	output.posTex = mul( output.position, g_shadowerTransform );
	output.depth = clamp(output.posTex.z / g_light_farPlane,0,1);

	output.position = mul(output.position, shader_transform_viewProj);
	
	return output;
}

////////////////////////////////////////////////////////////

sampler sample_colour_shadow = sampler_state 
{ 
	Texture = shader_texture_shadowmap; 
	AddressU = Clamp; 
	AddressV = Clamp; 
};

////////////////////////////////////////////////////////////

float4 ps_terrain_shadowed( VS_OUTPUT input ) : COLOR0
{
	// calculate shadowing

	float2 projTexCoords;
	projTexCoords.x = input.posTex.x / 2.0f + 0.5f;
	projTexCoords.y = -input.posTex.y / 2.0f + 0.5f;
	
	float shadowTerm = ((tex2D( sample_colour_shadow, projTexCoords ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( -shader_misc_shadow_mapTexelSize, 0.0f ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( shader_misc_shadow_mapTexelSize, 0.0f ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( 0.0f, -shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( 0.0f, shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( -shader_misc_shadow_mapTexelSize, -shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( shader_misc_shadow_mapTexelSize, -shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( -shader_misc_shadow_mapTexelSize, shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)
	 + (tex2D( sample_colour_shadow, projTexCoords + float2( shader_misc_shadow_mapTexelSize, shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? 0.0 : 1.0f)) / 9.0f;

	return float4(1,0,0,0); //saturate((1.0f-shadowTerm) - shader_light_ambient.r));
}


technique terrain_shadowed_11_20
{
	pass P0
	{
		AlphaBlendEnable = True;
		AlphaTestEnable = True;

		VertexShader = compile vs_1_1 vs_terrain_shadowed();	
		PixelShader = compile ps_2_0 ps_terrain_shadowed();	
	}
}
